using System;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls; 
using System.Collections.Specialized;
using System.Globalization;


	/// <summary>
	/// Various utilities for working with HTML that don't really fit into the page base/classes.
	/// </summary>
	public static class HtmlUtilities
	{
		/// <summary>
		/// The script that "clicks" the given button when the enter key is pressed.
		/// Allegedly this works on recent versions of both IE and Mozilla.
		/// </summary>
		private const string ClickButtonOnEnterKeyScript = @"<script language=Javascript>
			function clickButton(e, buttonid){
			var bt = document.getElementById(buttonid); 
			if (typeof bt == 'object'){ 
					if(navigator.appName.indexOf('Netscape')>(-1)){ 
						if (e.keyCode == 13){ 
								bt.click(); 
								return false; 
						} 
					} 
					if (navigator.appName.indexOf('Microsoft Internet Explorer')>(-1)){ 
						if (event.keyCode == 13){ 
								bt.click(); 
								return false; 
						} 
					} 
				} 
			}
			</script>";	

		/// <summary>
		/// Safely get a positive integer out of the request's query string with the specified key.
		/// </summary>
		/// <param name="request"></param>
		/// <param name="key"></param>
		/// <returns>The key value if found and well-formed, -1 otherwise.</returns>
		public static int GetPositiveIntFromQueryString( HttpRequest request, string key )
		{
			int returnVal = -1;

			if( request.QueryString[key] != null )
                int.TryParse(request.QueryString[key], out returnVal);

			return returnVal;
		}

		/// <summary>
		/// Get an array list of all selected/deselected  items out of a set of checkboxlists.
		/// </summary>
		/// <param name="selected">True if we want the selected values, False if we want the unselected ones.</param>
		/// <param name="checkBoxLists"></param>
		/// <returns></returns>
		public static StringCollection GetCheckBoxListValues( bool selected, params CheckBoxList[] checkBoxLists )
		{
			StringCollection retVal = new StringCollection();

			foreach( CheckBoxList cbl in checkBoxLists )
			{
				foreach( ListItem li in cbl.Items )
				{
					if( li.Selected == selected  )
					{
						retVal.Add( li.Value );
					}
				}
			}

			return retVal;
		}

		/// <summary>
		/// Return a keypress event handler that clicks the given button when the enter key is pressed, and
		/// register the associated script to pull this off.
		/// </summary>
		/// <param name="page">The page we're working on.</param>
		/// <param name="buttonToClick">The button we want to click when 'enter' is pressed.</param>
		/// <returns></returns>
		public static string ClickButtonOnEnterKey( Page page, Control buttonToClick )
		{
			const string scriptName = "__ClickButtonOnEnterKeyScript";
			if( !page.ClientScript.IsClientScriptIncludeRegistered( scriptName ) )
			{
				page.ClientScript.RegisterClientScriptBlock( page.GetType(), scriptName, ClickButtonOnEnterKeyScript );
			}

			return String.Format( CultureInfo.InvariantCulture, "return clickButton(event,'{0}')", buttonToClick.ClientID );
		}

		/// <summary>
		/// Redirect to a safe location in case of an error and the error page doesn't apply.
		/// We assume the corporate site is such a location.
		/// </summary>
		/// <param name="response"></param>
		public static void RedirectToSafeLocation( HttpResponse response )
		{
			response.Redirect( "Default.aspx" );
		}

		
	}

